<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Acme Themes
 * @subpackage Weblog
 */
global $weblog_customizer_all_values;
$no_image ='';
if( !has_post_thumbnail() || $weblog_customizer_all_values['weblog-blog-archive-layout'] != 'full-image' ){
	$no_image = 'acme-no-image';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('acme-col-3 masonry-post'); ?>>
	<div class="inner-wrapper <?php echo $no_image?>">
		<?php
		if( has_post_thumbnail() && $weblog_customizer_all_values['weblog-blog-archive-layout'] == 'full-image' ){
			?>
			<!--post thumbnal options-->
			<div class="post-thumb">
				<?php
				if( is_sticky() ){
					?>
					<a href="<?php the_permalink(); ?>">
						<span class="fa fa-sticky-note sticky-format-icon"></span>
					</a>
					<?php
				}
				?>
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail('large')?>
				</a>
				<?php if ( 'post' === get_post_type() ) : ?>
					<div class="entry-meta">
						<?php weblog_posted_on(); ?>
					</div><!-- .entry-meta -->
				<?php endif; ?>
				<a href="<?php the_permalink(); ?>">
					<span class="format-icon"></span>
				</a>
			</div><!-- .post-thumb-->
			<?php
		}
		else{
			if ( 'post' === get_post_type() ) : ?>
				<div class="entry-meta">
					<?php weblog_posted_on(); ?>
				</div><!-- .entry-meta -->
			<?php endif;
		}
		?>
		<header class="entry-header">
			<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
		</header><!-- .entry-header -->
		<footer class="entry-footer">
			<?php weblog_entry_footer( 1, 0 , 0 ); ?>
		</footer><!-- .entry-footer -->
		<div class="entry-content">
			<?php the_excerpt(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'weblog' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
	<div class="read-more"><a href="<?php the_permalink()?>" class="read-more-btn"><?php _e('Read More','weblog')?> </a></div>
	</div>
	
</article><!-- #post-## -->
