<?php
/**
 * Display related posts from same category
 *
 * @since weblog 1.0.0
 *
 * @param int $post_id
 * @return void
 *
 */
if ( !function_exists('weblog_related_post_below') ) :

    function weblog_related_post_below( $post_id ) {

        global $weblog_customizer_all_values;
        if( 0 == $weblog_customizer_all_values['weblog-show-related'] ){
            return;
        }
        $categories = get_the_category( $post_id );
        if ($categories) {
            $category_ids = array();
            foreach ($categories as $category) {
                $category_ids[] = $category->term_id;
            }
            ?>
            <div class="related-post-wrapper">
                <h2 class="widget-title">
                    <?php _e('Related posts', 'weblog'); ?>
                </h2>
                <div class="featured-entries-col featured-entries featured-col-posts featured-related-posts">
                    <?php
                    $weblog_cat_post_args = array(
                        'category__in'       => $category_ids,
                        'post__not_in'       => array($post_id),
                        'post_type'          => 'post',
                        'posts_per_page'     => 3,
                        'post_status'        => 'publish',
                        'ignore_sticky_posts'=> true
                    );
                    $weblog_featured_query = new WP_Query( $weblog_cat_post_args );

                    while ( $weblog_featured_query->have_posts() ) : $weblog_featured_query->the_post();
                        ?>
                        <div class="acme-col-3">
                            <?php
                            if ( has_post_thumbnail() ):
                                ?>
                                <figure class="widget-image">
                                    <a href="<?php the_permalink()?>">
                                        <?php the_post_thumbnail('medium');?>
                                    </a>
                                </figure>
                                <?php
                            endif;
                            ?>
                            <div class="featured-desc">
                                <div class="above-entry-meta">
                                    <?php
                                    $archive_year  = get_the_date('Y');
                                    $archive_month = get_the_date('m');
                                    $archive_day   = get_the_date('d');
                                    ?>
                                    <span>
                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                            <i class="fa fa-calendar"></i>
                                            <?php echo esc_html( get_the_date('F d, Y') ); ?>
                                        </a>
                                    </span>
                                </div>
                                <a href="<?php the_permalink()?>">
                                    <h4 class="title">
                                        <?php the_title(); ?>
                                    </h4>
                                </a>
                            </div>
                        </div>
                        <?php
                    endwhile;
                    wp_reset_query();
                    ?>
                </div>
                <div class="clearfix"></div>
            </div>
            <?php
        }
    }

endif;

add_action( 'weblog_related_posts', 'weblog_related_post_below', 10, 1 );