<?php
/**
 * Reset options
 * Its outside options panel
 *
 * @param  array $reset_options
 * @return void
 *
 * @since weblog 1.0.0
 */
if ( ! function_exists( 'weblog_reset_db_options' ) ) :
    function weblog_reset_db_options( $reset_options ) {
        set_theme_mod( 'weblog_theme_options', $reset_options );
    }
endif;

function weblog_reset_setting_callback( $input, $setting ){
    // Ensure input is a slug.
    $input = sanitize_text_field( $input );
    if( '0' == $input ){
        return '0';
    }
    $weblog_default_theme_options = weblog_get_default_theme_options();
    $weblog_get_theme_options = get_theme_mod( 'weblog_theme_options');

    switch ( $input ) {
        case "reset-color-options":
            $weblog_get_theme_options['weblog-primary-color'] = $weblog_default_theme_options['weblog-primary-color'];
            weblog_reset_db_options($weblog_get_theme_options);
            break;

        case "reset-all":
            weblog_reset_db_options($weblog_default_theme_options);
            break;

        default:
            break;
    }
}
/*adding sections for Reset Options*/
$wp_customize->add_section( 'weblog-reset-options', array(
    'priority'       => 220,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __( 'Reset Options', 'weblog' )
) );

/*Reset Options*/
$wp_customize->add_setting( 'weblog_theme_options[weblog-reset-options]', array(
    'capability'		=> 'edit_theme_options',
    'default'			=> $defaults['weblog-reset-options'],
    'sanitize_callback' => 'weblog_reset_setting_callback',
    'transport'			=> 'postMessage'
) );

$choices = weblog_reset_options();
$wp_customize->add_control( 'weblog_theme_options[weblog-reset-options]', array(
    'choices'  	    => $choices,
    'label'		    => __( 'Reset Options', 'weblog' ),
    'description'   => __( 'Caution: Reset theme settings according to the given options. Refresh the page after saving to view the effects. ', 'weblog' ),
    'section'       => 'weblog-reset-options',
    'settings'      => 'weblog_theme_options[weblog-reset-options]',
    'type'	  	    => 'select'
) );