<?php
if ( class_exists( 'WP_Customize_Control' ) && ! class_exists( 'Weblog_Customize_Category_Dropdown_Control' )):

    /**
     * Custom Control for category dropdown
     * @package Acme Themes
     * @subpackage Weblog
     * @since 1.0.0
     *
     */
    class Weblog_Customize_Category_Dropdown_Control extends WP_Customize_Control {

        /**
         * Declare the control type.
         *
         * @access public
         * @var string
         */
        public $type = 'category_dropdown';

        /**
         * Function to  render the content on the theme customizer page
         *
         * @access public
         * @since 1.0.0
         *
         * @param null
         * @return void
         *
         */
        public function render_content() {
            $weblog_customizer_name = 'weblog_customizer_dropdown_categories_' . $this->id;;
            $weblog_dropdown_categories = wp_dropdown_categories(
                array(
                    'name'              => $weblog_customizer_name,
                    'echo'              => 0,
                    'show_option_none'  =>__('Select','weblog'),
                    'option_none_value' => '0',
                    'selected'          => $this->value(),
                )
            );
            $weblog_dropdown_final = str_replace( '<select', '<select ' . $this->get_link(), $weblog_dropdown_categories );
            printf(
                '<label><span class="customize-control-title">%s</span> %s</label>',
                $this->label,
                $weblog_dropdown_final
            );
            if ( !empty( $this->description ) ) {
                echo "<br />";
                echo esc_html($this->description);
            }
        }
    }
    endif;
if ( class_exists( 'WP_Customize_Control' ) && ! class_exists( 'Weblog_Customize_Post_Dropdown_Control' )):

    /**
     * Custom Control for post dropdown
     * @package Acme Themes
     * @subpackage Weblog
     * @since 1.0.0
     *
     */
    class Weblog_Customize_Post_Dropdown_Control extends WP_Customize_Control {
        /**
         * Declare the control type.
         *
         * @access public
         * @var string
         */
        public $type = 'post_dropdown';

        /**
         * Function to  render the content on the theme customizer page
         *
         * @access public
         * @since 1.0.0
         *
         * @param null
         * @return void
         *
         */
        public function render_content() {
            $weblog_customizer_post_args = array(
                'posts_per_page'   => -1,
            );
            $weblog_posts = get_posts( $weblog_customizer_post_args );
            if(!empty($weblog_posts))  {
                ?>
                <label>
                    <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
                    <select <?php $this->link(); ?>>
                        <?php
                        $weblog_default_value = $this->value();
                        if( -1 == $weblog_default_value || empty($weblog_default_value)){
                            $weblog_default_selected = 1;
                        }
                        else{
                            $weblog_default_selected = 0;
                        }
                        printf('<option value="-1" %s>%s</option>',selected($weblog_default_selected, 1, false),__('Select','weblog'));
                        foreach ( $weblog_posts as $weblog_post ) {
                            printf('<option value="%s" %s>%s</option>', $weblog_post->ID, selected($this->value(), $weblog_post->ID, false), $weblog_post->post_title);
                        }
                        ?>
                    </select>
                </label>
                <?php
            }
        }
    }
endif;

if ( class_exists( 'WP_Customize_Control' ) && ! class_exists( 'Weblog_Customize_Message_Control' )):
    /**
     * Custom Control for html display
     * @package Acme Themes
     * @subpackage Weblog
     * @since 1.0.0
     *
     */
    class Weblog_Customize_Message_Control extends WP_Customize_Control {

        /**
         * Declare the control type.
         * @access public
         * @var string
         */
        public $type = 'message';

        /**
         * Function to  render the content on the theme customizer page
         *
         * @access public
         * @since 1.0.0
         *
         * @param null
         * @return void
         *
         */
        public function render_content() {
            if ( empty( $this->description ) ) {
                return;
            }
            ?>
            <div class="weblog-customize-customize-message">
                <?php echo wp_kses_post($this->description); ?>
            </div> <!-- .weblog-customize-customize-message -->
            <?php
        }
    }
endif;