<?php
/**
 * Jetpack Compatibility File.
 *
 * @link https://jetpack.me/
 *
 * @package Acme Themes
 * @subpackage Weblog
 */

/**
 * Add theme support for Infinite Scroll.
 * See: https://jetpack.me/support/infinite-scroll/
 */
if ( ! function_exists( 'weblog_jetpack_setup' ) ) :
	function weblog_jetpack_setup() {
		add_theme_support( 'infinite-scroll', array(
			'container' => 'main',
			'render'    => 'weblog_infinite_scroll_render',
			'footer'    => 'page',
		) );
	} // end function weblog_jetpack_setup
endif;
add_action( 'after_setup_theme', 'weblog_jetpack_setup' );

/**
 * Custom render function for Infinite Scroll.
 */
if ( ! function_exists( 'weblog_infinite_scroll_render' ) ) :
	function weblog_infinite_scroll_render() {
		while ( have_posts() ) {
			the_post();
			get_template_part( 'template-parts/content', get_post_format() );
		}
	} // end function weblog_infinite_scroll_render
endif;
